function veh = updateMass(veh)

pwtMass = veh.wh.mass + veh.fd.mass + veh.gb.mass;

switch veh.vehType
    case 'conv'
        pwtMass = pwtMass + veh.eng.mass;
    case 'bev'
        pwtMass = pwtMass + veh.em.mass + veh.batt.mass;
end
if isfield(veh, 'supercap')
    pwtMass = pwtMass + veh.cap.mass;
end
if isfield(veh, 'dynCh')
    pwtMass = pwtMass + veh.dynCh.mass;
end

% Masses 
% Curb mass:
%   The user defines either curbMass or chassisMass
%       - If curbMass is specified, that is exactly the curb mass of the
%       vehicle and the components weights are ignored. 
%       - If chassisMass is specified instead, the curb mass is the sum of
%       chassisMass and the components' weights.
% Load mass:
%   The user defines either maxLoad or grossMass
%       - If maxLoad is specified, that is the maximum payload. 
%       - If grossMass is specified, the maximum load weight is obtained
%       as the difference between (regulatory) gross weight and curb mass;
%       this is useful for HD applications

% Curb mass
veh.body.curbMass = veh.body.chassisMass + pwtMass;


% Add load mass to the vehicle body mass
veh.body.maxLoad = veh.body.grossMass - veh.body.curbMass;


end